function []=iteracija(E)

% Funkcija racuna priblizno resenje jednacine 4.*exp(x)=5.*(x+1) sa unapred
% zadatom tacnoscu E 
% Resenje - resenje dobijeno prostom iterativnom metodom
% Resenja - resenja dobijena modifikovanom iterativnom metodom
% Polazna jednacina je ekvivalentna sa f(x)=4.*exp(x)-5.*(x+1)

% Ako polaznu jednacinu podelimo na dve funkcije g(x)=4.*exp(x) i
% h(x)=5.*(x+1), na osnovu njihovih grafika mozemo videti da se one
% seku u tacno 2 tacke, i te tacke su resenja nase jednacine

% Jedno resenje se nalazi na segmentu [-1,0] a drugo na segmentu [0.5,1],
% sto se moze proveriti:
% f(-1)=1.47152 >0
% f(0)=-1.00000 <0
% pa je i f(-1)*f(0)<0, tako da je sigurno da se jedno resenje nalazi na [-1,0]
% Prvi izvod funkcije f(x) je f'(x)=4.*exp(x)-5, a drugi f"(x)=4.*exp(x) i on je 
% uvek veci od nule, pa odavde zakljucujemo da je prvi izvod rastuci na
% intervalu (-1,0), a posto su 
% f'(-1)=-3.52848 <0 i 
% f'(0)=-1.00000 <0
% to je cela funkcija f'(x)<0 na intervalu (-1,0)
% Posto je izvod rastuca funkcija na (-1,0), njegov minimum na intervalu (-1,0) 
% je u tacki -1, i iznosi f'(-1)=-3.52848
m=-3.52848;
% a maksimum  izvoda na intervalu (-1,0) je u tacki 0, i iznosi f'(0)=-1.00000
M=-1.00000;

% Pozivanjem funkcije ModIteracija() dobicemo prvo resenje metodom
% modifikovane iteracije:
[Resenja(1) j]=ModIteracija(E, M, m, [-1 0]);

% Pozivanjem funkcije Iteracija() dobicemo priblizno resenje jednacine metodom 
% proste iteracije:
[Resenje nj]=Iteracija(E);

% A zatim cemo sve to proveriti i za interval (0.5,1)
% f(0.5)=-0.90512 <0
% f(1)=0.87313 >0
% pa je i f(0.5)*f(1)<0, tako da je sigurno da se jedno resenje nalazi na (0.5,1)
% Prvi izvod funkcije f(x) je f'(x)=4.*exp(x)-5, i on je rastuc na
% intervalu (0.5,1), a posto je 
% f'(0.5)=1.59488 >0 i
% f'(1)=5.87313 >0  
% to je cela funkcija f'(x)>0 na intervalu (0.5,1)
% Posto je izvod rastuca funkcija, minimum izvoda na intervalu (0.5,1) je
% u tacki 0.5, tj.
m=1.59488;
% a maksimum izvoda na intervalu (0.5,1) je u tacki 1, tj.
M=5.87313;

% Pozivanjem funkcije ModIteracija() dobicemo i drugo resenje
% metodom modifikovane iteracije
[Resenja(2) zx]=ModIteracija(E,M,m,[0.5 1]);

% Pozivanjem funkcije Iter() dobicemo drugo priblizno resenje jednacine 
% metodom proste iteracije:
%[Resenje(2) zj]=Iter(E)


disp('Resenje dobijeno prostom iterativnom metodom je ')
Resenje
disp('A resenja dobijena modifikovanom iterativnom metodom su')
Resenja

% Sada crtamo grafik zavisnosti brzine konvergencije od trazene tacnosti
% Brojacemo broj iteracija potrebnih za dobijanje resenja moodifikovanom
% iterativnom metodom na intervalu (-1,0)
j=1;
for tacno=1.0e-7:4.0e-6:1.0e-3
    [Resenja i]=ModIteracija(tacno,M,m,[-1 0]);
    MIt(j)=i;
    [Resenje k]=Iteracija(tacno);
    It(j)=k;
    T(j)=tacno;
    j=j+1;
end
plot(T,MIt, 'r', 'LineWidth',2)
grid on
hold on
plot(T,It, 'b', 'LineWidth',2)
gtext('MIt')
gtext('It')


% A zatim cemo grafiku dodati i resenje nase jednacine  
%plot(E, zx, 'r--')
%plot(E,nj)
title('Grafik zavisnosti brzine konvergencije od trazene tacnosti')
ylabel('Broj iteracija potrebnih za dobijanje resenja')
xlabel('Trazena tacnost')
hold off